﻿using System;
using System.Web;
using System.Web.Security.AntiXss;
using VIRP.EFR.BLL;
using VIRP.EFR.DAL;
using VIRP_WEB.BaseCode;

namespace VIRP_WEB.Custom.EFR
{
    public partial class DoDFragmentLabDelete : EfrBasePage
    {
        private DoDFragmentDB manager = new DoDFragmentDB();
        protected readonly string DoDFragmentPage = "~/Custom/EFR/DoDFragment/DoDFragment.aspx?patientId=";
        private string pFullName = "";

        protected override void Page_Load(object sender, EventArgs e)
        {
            DisplayPatientInfo();
            ReplacePageTitle("Patients > Patient Lookup > Workflows > DoD Fragment Data > " + pFullName);

            HiddenFieldPatientID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["patientId"], false);
            HiddenFieldDoDFragmentLabID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["dodFragmentLabId"], false);

            DOD_FRAGMENT_LAB lab = manager.GetDoDFragmentLabById(Helpers.GetIntFromString(Request.QueryString["dodFragmentLabId"].ToString()));
            //lab.SetAsChangeTrackingRoot();
            //lab.SetAsDeleteOnSubmit();

            //manager.Update(lab);

            DOD_FRAGMENT_LABManager.Delete(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, lab.DOD_FRAGMENT_LAB_ID);

            ResponseRedirect(DoDFragmentPage, HiddenFieldPatientID.Value);
        }

        private void DisplayPatientInfo()
        {
            if (!string.IsNullOrEmpty(BaseCode.Helpers.AntiXssEval(Request.QueryString["patientId"])))
            {
                int patientId = Convert.ToInt32(BaseCode.Helpers.AntiXssEval(Request.QueryString["patientId"]));

                VIRP.CRS.BO.PATIENT p = VIRP.CRS.BLL.PATIENTManager.GetItem(CurrentUser, CurrentRegistryId, patientId);
                VIRP.CRS.BO.PATIENT_REG pr = VIRP.CRS.BLL.PATIENT_REGManager.GetItem(CurrentUser, CurrentRegistryId, patientId);

                if (p != null)
                {
                    pFullName = p.FULL_NAME;
                }
            }
        }

        private void ResponseRedirect(string destination, string queryString)
        {
            try
            {
                string queryStringValue = string.Empty;
                if (queryString != null)
                {
                    queryStringValue = AntiXssEncoder.UrlEncode(queryString);
                }

                string destinationUrl = string.Concat(destination, queryStringValue);
                string currentHost = Request.Url.Host;
                if (Helpers.IsDestinationUrlLocal(destinationUrl, currentHost))
                {
                    Server.Transfer(destinationUrl);
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError("Failure in to redirect to Export page: - DOD Fragment page: " + ex.ToString(), String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
            }
        }
    }
}